package nemosofts.voxradio.adapter.Home;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.nemosofts.view.RoundedImageView;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.squareup.picasso.Picasso;

import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.asyncTask.LoadStatus;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.SharedPref;
import nemosofts.voxradio.utils.helper.Helper;

public class AdapterHomeRadio extends RecyclerView.Adapter<AdapterHomeRadio.MyViewHolder> {

    private final Context context;
    private final Helper helper;
    private final SharedPref sharedPref;
    private final List<ItemRadio> arrayList;
    private final RecyclerItemClickListener listener;

    public AdapterHomeRadio(Context context, List<ItemRadio> arrayList, RecyclerItemClickListener listener) {
        this.arrayList = arrayList;
        this.context = context;
        this.listener = listener;
        helper = new Helper(context);
        sharedPref = new SharedPref(context);
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {

        private final RoundedImageView iv_radio;
        private final TextView tv_title;
        private final TextView tv_title_sub;
        private final ImageView iv_list_option;
        private final RelativeLayout rl_radio_home;

        MyViewHolder(View view) {
            super(view);
            iv_radio = itemView.findViewById(R.id.iv_radio);
            tv_title = itemView.findViewById(R.id.tv_radio_name);
            tv_title_sub = itemView.findViewById(R.id.tv_radio_cat);
            iv_list_option = view.findViewById(R.id.iv_list_option);
            rl_radio_home = view.findViewById(R.id.rl_radio_home);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_radio, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.tv_title.setText(arrayList.get(position).getRadioTitle());
        holder.tv_title_sub.setText(arrayList.get(position).getCategoryName());
        Picasso.get()
                .load(arrayList.get(position).getImage())
                .resize(300,300)
                .placeholder(R.drawable.material_design_default)
                .into(holder.iv_radio);

        holder.iv_list_option.setOnClickListener(view -> {
            try {
                openBottomSheet(holder.getAbsoluteAdapterPosition());
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

        holder.rl_radio_home.setOnClickListener(view -> listener.onClick(holder.getAbsoluteAdapterPosition()));
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    private void openBottomSheet(int adapterPosition) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams") View view = inflater.inflate(R.layout.bottom_sheet_radio, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);

        TextView tv_sheet_text = dialog.findViewById(R.id.tv_sheet_text);
        TextView tv_sheet_list_cat = dialog.findViewById(R.id.tv_sheet_list_cat);
        RoundedImageView iv_sheet_post = dialog.findViewById(R.id.iv_sheet_post);

        LinearLayout ll_sheet_report = dialog.findViewById(R.id.ll_sheet_report);
        LinearLayout ll_sheet_share = dialog.findViewById(R.id.ll_sheet_share);
        LinearLayout ll_sheet_fav = dialog.findViewById(R.id.ll_sheet_fav);
        LinearLayout ll_sheet_rating = dialog.findViewById(R.id.ll_sheet_rating);
        LinearLayout ll_sheet_youtube = dialog.findViewById(R.id.ll_sheet_youtube);

        ImageView iv_turned = dialog.findViewById(R.id.iv_turned);
        TextView tv_turned = dialog.findViewById(R.id.tv_turned);
        if (iv_turned != null && tv_turned != null){
            if (Boolean.TRUE.equals(arrayList.get(adapterPosition).IsFav())) {
                tv_turned.setText(context.getResources().getString(R.string.un_favourite));
                iv_turned.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_turned_in,null));
            } else {
                tv_turned.setText(context.getResources().getString(R.string.add_favourite));
                iv_turned.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_turned_in_not,null));
            }
        }

        if (iv_sheet_post != null){
            Picasso.get()
                    .load(arrayList.get(adapterPosition).getImage())
                    .centerCrop()
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .into(iv_sheet_post);
        }

        Objects.requireNonNull(tv_sheet_list_cat).setText(arrayList.get(adapterPosition).getCategoryName());
        Objects.requireNonNull(tv_sheet_text).setText(arrayList.get(adapterPosition).getRadioTitle());
        Objects.requireNonNull(ll_sheet_report).setOnClickListener(view2 -> {
            new FeedBackDialog((Activity) context).showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getRadioTitle());
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_share).setOnClickListener(view3 -> {
            Intent sharingIntent = new Intent(Intent.ACTION_SEND);
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra(Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.share_radio));
            sharingIntent.putExtra(Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - " + arrayList.get(adapterPosition).getRadioTitle() + "\n\nvia " + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
            context.startActivity(Intent.createChooser(sharingIntent, context.getResources().getString(R.string.share_radio)));
        });
        Objects.requireNonNull(ll_sheet_fav).setOnClickListener(view4 -> {
            loadFav(adapterPosition);
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_rating).setOnClickListener(view5 -> {
            ReviewDialog reviewDialog = new ReviewDialog((Activity) context, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {

                }

                @Override
                public void onGetRating(String rating, String message) {
                    arrayList.get(adapterPosition).setUserRating(String.valueOf(rating));
                    arrayList.get(adapterPosition).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating, String userRating, String userMessage) {
                    if (success.equals("1")) {
                        if (rateSuccess.equals("1")) {
                            try {
                                arrayList.get(adapterPosition).setAverageRating(String.valueOf(rating));
                                arrayList.get(adapterPosition).setTotalRate(String.valueOf(Integer.parseInt(arrayList.get(adapterPosition).getTotalRate() + 1)));
                                arrayList.get(adapterPosition).setUserRating(String.valueOf(userRating));
                                arrayList.get(adapterPosition).setUserMessage(String.valueOf(userMessage));
                                notifyItemChanged(adapterPosition);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }
            });
            reviewDialog.showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getUserRating(), arrayList.get(adapterPosition).getUserMessage());
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_youtube).setOnClickListener(view6 -> {
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(adapterPosition).getRadioTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            dialog.dismiss();
        });
        dialog.show();
    }

    private void loadFav( int adapterPosition) {
        if(sharedPref.isLogged()) {
            if (helper.isNetworkAvailable()) {
                LoadStatus loadFav = new LoadStatus(new SuccessListener() {
                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onEnd(String success, String favSuccess, String message) {
                        if (success.equals("1")) {
                            arrayList.get(adapterPosition).setIsFav(message.equals("Added to Favourite"));
                            notifyItemChanged(adapterPosition);
                            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    }
                }, helper.getAPIRequest(Callback.METHOD_DO_FAV, 0, arrayList.get(adapterPosition).getId(), "", "", "", sharedPref.getUserId(), "", "", "", "", "", "", "radio", null));
                loadFav.execute();
            } else {
                Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            if(!sharedPref.isLogged()) {
                helper.clickLogin();
            }
        }
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
    }
}